//speedopt.c
//
//This file contains a collection of
//non-PToolboxLib related PocketC speed 
//optimizations.
//
//Assembled by Joseph Stadolnik
//
//NOTE: This file is over 4k in size
// and will not fit in a Palm memo.

int t;
int e;
int m1, m2, m3, m4;

//Declare some helper functions
start() { 
  t=ticks(); 
}

stop(string s) { 
  puts(s+": "+(ticks()-t)+"\n"); 
}

func1(pointer a) { *a=*a; }
func2(pointer a) { *a=*a; }
func3(pointer a) { *a=*a; }
func4(pointer a) { *a=*a; }

int func5(int x1, int x2, int x3, int x4) { 
	return(x1+x2+x3+x4); 
}
int func6() { return(m1+m2+m3+m4); }

//MAIN
main() {

int v, w, x, y, z, c[4];
pointer a, b, d[4];
int k[1000];
clear();

a = malloc(2000);

//1. Assign case

start();
x=1000;
while(x--) {
a[0]=0;
a[1]=0;
a[2]=0;
a[3]=0;
a[4]=0;
a[5]=0;
a[6]=0;
a[7]=0;
}
stop("1. Assign - slow");

start();
x=1000;
while(x--) {
a[0]=a[1]=a[2]=a[3]=a[4]=a[5]=a[6]=a[7]=0;
}
stop("1. Assign - fast");

//2. Loop case

start();
for(x=0;x<1000;x++) a[x]=0;
stop("2. Loop - slow");

start();
x=1000;
while(x--) a[x]=0;
stop("2. Loop - fast");

//3. Zero Branch case

start();
x=1000;
while(x--) if(a[x]==0) a[x]=0;
stop("3. Zero Branch - slow");

start();
x=1000;
while(x--) if(!a[x]) a[x]=1;
stop("3. Zero Branch - fast");

//4. Non-Zero Branch case

start();
x=1000;
while(x--) if(a[x]!=0) a[x]=1;
stop("4. Non-Zero Branch - slow");

start();
x=1000;
while(x--) if(a[x]) a[x]=1;
stop("4. Non-Zero Branch - fast");

//NOTE: if(a[x]) is faster than if(!a[x]),  
// the "!" operator slows things down. 
// Also "==" is slightly faster than "!=".

//5. Nested Branches case

z=1;
y=1;
w=1;
v=0;

start();
x=1000;
while(x--) {
  if(y && z && w) v++;
}
stop("5. Nested Branches - slow");

start();
x=1000;
z=1;
while(x--) {
  if(y) if(z) if(w) v++;
}
stop("5. Nested Branches - fast");

//6. Increment [] case

start();
x=1000;
y=0;
while(x--) {
  a[y]=0;
  y++;  
}
stop("6. Increment [] - slow");

start();
x=1000;
y=0;
while(x--) {
  a[y++]=0;
}
stop("6. Increment [] - fast");

//7. Increment if() case

start();
x=1000;
y=0;
while(x--) {
  ++y;
  if(y) z=0; 
}
stop("7. Increment if() - slow");

start();
x=1000;
y=0;
while(x--) {
  if(++y) z=0;
}
stop("7. Increment if() - fast");

//NOTE: Decrement operator "--" works just as well as "++".

//8. Nested/Non-Nested [] case

x=1000;
while(x--) a[x]=x%4; //fill array with data

start();
x=1000;
while(x--) { 
  y=a[x]; 
  c[y]=0; 
}
stop("8. Non-Nested []'s - slow");

start();
x=1000;
while(x--) {
  c[a[x]]=0;
}
stop("8. Nested []'s - fast");

//9. Switch vs. If-Else

start();
x=1000;
while(x--) {
	y=a[x];
	if(y==0) e = e - 1;
	else if(y==1) e = e + 1;
	else if(y==2) e = e - 10;
	else if(y==3) e = e + 10;
}
stop("9. If-else - slow");

start();
x=1000;
while(x--) {
	switch(a[x]) {
	 case 0 : e = e - 1; break;
	 case 1 : e = e + 1; break;
	 case 2 : e = e - 10; break;
	 case 3 : e = e + 10;
	}
}
stop("9. Switch - fast");

//10. Translate case

start();
x=1000;
while(x--) {
	switch(a[x]) {
	 case 0: z=-1; break;
	 case 1: z=1; break;
	 case 2: z=-10; break;
	 case 3: z=10;
	}
}
stop("10. Translate - slow");

c[0]=-1;
c[1]=1;
c[2]=-10;
c[3]=10;

start();
x=1000;
while(x--) z=c[a[x]];
stop("10. Translate - fast");

//11. Function select case

start();
x=1000;
while(x--) {
	switch(a[x]) {
	 case 0 : func1(&a[x]); break;
	 case 1 : func2(&a[x]); break;
	 case 2 : func3(&a[x]); break;
	 case 3 : func4(&a[x]);
	}
}
stop("11. Function select - slow");

d[0]=func1;
d[1]=func2;
d[2]=func3;
d[3]=func4;

start();
x=1000;
while(x--) (*d[a[x]])(&a[x]);
stop("11. Function select - fast");

//12. Nested/Unrolled Loop case

start();
z=10;
while(z--) {
  x=10;
  while(x--) {
    y=10;
    while(y--) a[(10*y)+x]=1;
  }
}
stop("12. Nested Loop - slow");

start();
z=10;
while(z--) {
  x=10;
  while(x--) {
    a[x]=1;
    a[10+x]=1;
    a[20+x]=1;
    a[30+x]=1;
    a[40+x]=1;
    a[50+x]=1;
    a[60+x]=1;
    a[70+x]=1;
    a[80+x]=1;
    a[90+x]=1;
  }
}
stop("12. Unrolled Loop - fast");

//Create a 2x8 array of integers
free(a);
a=malloc(18);
a[0] = &a[2];
a[1] = &a[10];

//13. Multi-dimensional array indexing

start();
x=100; 
while(x--) {
  y=2; 
  while(y--) {
    z=8; 
    while(z--) a[y][z]=z;
  }
}
stop("13. Multi-Dim indexing - slow");

start();
x=100; 
while(x--) {
  y=2; 
  while(y--) {
    z=8;
    b=a[y]; 
    while(z--) b[z]=z;
  }
}
stop("13. Multi-Dim indexing - fast");

//14. Dereference case

start();
b=a;
x=2000;
while(x--) *(b++)=0;
stop("14. Dereference - slow");
//NOTE: The b++ increment makes this case slower.

start();
b=a;
x=2000;
while(x--) b[x]=0;
stop("14. Dereference - fast");
//NOTE: Also "*(b+x)" and "b[x]" are equally fast.

//15. Argument free functions

start();
x=1000;

while(x--) {
m1=1;
m2=2;
m3=3;
m4=4;
func5(m1,m2,m3,m4);
}
stop("15. With func args - slow");

start();
x=1000;
while(x--) {
m1=1;
m2=2;
m3=3;
m4=4;
func6();
}
stop("15. Without func args - fast");
//Note: This case uses global variables to avoid
// putting function arguments on the internal stack.  
// This also avoids type conversions.

graph_on();

//Build cosine & sine tables
free(a);
a=malloc(1024);
b=malloc(1024);
x=1024;
while(x--) {
  a[x] = 1024 * cos((x*2*3.1415926)/1024); //build cos table
  b[x] = 1024 * sin((x*2*3.1415926)/1024); //build sin table
}

//16. Trig lookup tables case

start();
z=1024;
while(z--) {
  //note: 0.0061359 = (2*PI)/1024
  x=100+(50*cos(z*0.0061359));
  y=100+(50*sin(z*0.0061359));
  line(1,x,y,x,y);
}
stop("16. Direct Trig calls - slow");

start();
z=1024;
while(z--) {
  x=60+((50*a[z])/1024);
  y=60+((50*b[z])/1024);
  line(1,x,y,x,y);
}
stop("16. Trig lookup tables - fast");

event(1);

}
